function []=rf_print_config(skt)
%function []=rf_print_config(skt)
% Version 1
% Ian Stothers May 2024


if(exist('skt')==0)
   skt.ip='192.168.1.4';
   ip=skt.ip;
else
  if (ischar(skt))
   ip=skt;
  else
   ip=skt.ip;
  endif
endif
if(exist('update_rate')==0)   update_rate=20; endif


if (ischar(skt))
  skt=sktopen(skt);
endif


STM32F103_bitfields; % Get some bitfields
  cfg_n=udpget(skt,'BuildTimeStamp');
  cfg_n=cfg_n(find(cfg_n~=' '));
  cfg_n=cfg_n(find(cfg_n~=':'));

AutoStart=udpget(skt,'AutoStart');
printf('\nAutoStart = %d\n',AutoStart);

DoTheDFT =   udpget(skt,'DoTheDFT');
printf('DoTheDFT = %d\n',DoTheDFT);

ADC_Scale = udpget(skt,'ADC_Scale');
ADC_Scale_st = disp(ADC_Scale);
printf('ADCScale = \n %s\n',ADC_Scale_st);

SRate= udpget(skt,'ADC_SR');
printf('SRate = %f\n',SRate);


  BuildName=udpget(skt,"BuildName");
  BuildName=BuildName(find(BuildName>0));
  printf('BuildName = %s\n',BuildName);

  BuildTimeStamp=udpget(skt,"BuildTimeStamp");
  BuildTimeStamp=BuildTimeStamp(find(BuildTimeStamp>0));
  printf('BuildTimeStamp = %s\n',BuildTimeStamp);

  PartSerno=udpget(skt,'PartSerno');
  printf('PartSerno = %d\n',PartSerno);

  TextPartNo=udpget(skt,'TextPartNo');
  TextPartNo=TextPartNo(1:min(find(TextPartNo==0)-1));
  printf('TextPartNo = %s\n',TextPartNo);





  Vcal=udpget(skt,'Vcal')*[1 ; i];
  printf('Vcal = %f %fi\n',real(Vcal),imag(Vcal));


   Ical=udpget(skt,'Ical')*[1 ; i];
   printf('Ical = %f %fi\n',real(Ical),imag(Ical));


   ADC_RC=udpget(skt,'ADC_RC');
   printf('ADC_RC = %e\n',ADC_RC);

  tfocs=udpget(skt,'tfoc');
  tfoc=tfocs(1)+i*tfocs(2);
  printf('tfoc = %f %fi\n',real(tfoc),imag(tfoc));



  tfscs=udpget(skt,'tfsc');
  tfsc=tfscs(1)+i*tfscs(2);
  printf('tfsc = %f %fi\n',real(tfsc),imag(tfsc));


endfunction
